/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.world.chunk;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.jayjay.dangerzone.block.Block;
import net.jayjay.dangerzone.entity.EntityPlayer;
import net.jayjay.dangerzone.phys.AABB;
import net.jayjay.dangerzone.render.Tesselator;
import net.jayjay.dangerzone.texture.Textures;
import net.jayjay.dangerzone.world.FaceToRender;
import net.jayjay.dangerzone.world.World;
import net.jayjay.dangerzone.world.chunk.ChunkCache;
import org.lwjgl.opengl.GL11;

public class Chunk {
    public AABB aabb;
    public final World level;
    public final int x0;
    public final int y0;
    public final int z0;
    public final int x1;
    public final int y1;
    public final int z1;
    public final float x;
    public final float y;
    public final float z;
    private boolean dirty = true;
    private int lists = -1;
    public long dirtiedTime = 0L;
    private static Tesselator t = Tesselator.INSTANCE;
    public static int updates = 0;
    public static long totalTime = 0L;
    public static int totalUpdates = 0;
    public static final int CHUNK_SIZE = 16;

    public Chunk(World level, int x0, int y0, int z0, int x1, int y1, int z1) {
        this.level = level;
        this.x0 = x0;
        this.y0 = y0;
        this.z0 = z0;
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
        this.x = (float)(x0 + x1) / 2.0f;
        this.y = (float)(y0 + y1) / 2.0f;
        this.z = (float)(z0 + z1) / 2.0f;
        this.aabb = new AABB(x0, y0, z0, x1, y1, z1);
        this.lists = GL11.glGenLists(2);
    }

    private void rebuild(int layer) {
        this.dirty = false;
        ++updates;
        long before = System.nanoTime();
        ChunkCache cache = new ChunkCache(this.level, this.x0, this.y0, this.z0, this.x1, this.y1, this.z1);
        GL11.glNewList(this.lists + layer, 4864);
        HashMap<String, List<FaceToRender>> facesByTexture = new HashMap<String, List<FaceToRender>>();
        int x = this.x0;
        while (x < this.x1) {
            int y = this.y0;
            while (y < this.y1) {
                int z = this.z0;
                while (z < this.z1) {
                    Block block;
                    int blockId = cache.getBlock(x, y, z);
                    if (blockId > 0 && (block = cache.getBlockObject(x, y, z)) != null) {
                        if (this.hasCustomRender(block)) {
                            String texture = block.texturePath != null ? block.texturePath : "";
                            facesByTexture.computeIfAbsent(texture, k -> new ArrayList()).add(new FaceToRender(x, y, z, -1, block, true));
                        } else {
                            this.collectFacesToRender(block, cache, layer, x, y, z, facesByTexture);
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        int tiles = 0;
        for (Map.Entry entry : facesByTexture.entrySet()) {
            if (entry.getKey() != null && !((String)entry.getKey()).isEmpty()) {
                Textures.bindNearest((String)entry.getKey());
            }
            t.begin(7);
            for (FaceToRender face : (List)entry.getValue()) {
                if (face.isCustom) {
                    t.flush();
                    face.block.render(t, this.level, layer, face.x, face.y, face.z);
                    t.begin(7);
                    ++tiles;
                    continue;
                }
                this.renderBlockFace(face.block, face.x, face.y, face.z, face.faceIndex);
            }
            t.flush();
        }
        GL11.glEndList();
        long nTime = System.nanoTime();
        if (tiles > 0) {
            totalTime += nTime - before;
            ++totalUpdates;
        }
    }

    private boolean hasCustomRender(Block block) {
        return block.hasCustomModel();
    }

    private void renderBlock(Block block, ChunkCache cache, int layer, int x, int y, int z) {
        float topBrightness = 1.0f;
        float sideBrightness1 = 0.8f;
        float sideBrightness2 = 0.6f;
        if (this.shouldRenderFace(block, cache, x, y - 1, z, layer, 0)) {
            t.setColor(topBrightness, topBrightness, topBrightness);
            block.renderFace(t, x, y, z, 0);
        }
        if (this.shouldRenderFace(block, cache, x, y + 1, z, layer, 1)) {
            t.setColor(topBrightness, topBrightness, topBrightness);
            block.renderFace(t, x, y, z, 1);
        }
        if (this.shouldRenderFace(block, cache, x, y, z - 1, layer, 2)) {
            t.setColor(sideBrightness1, sideBrightness1, sideBrightness1);
            block.renderFace(t, x, y, z, 2);
        }
        if (this.shouldRenderFace(block, cache, x, y, z + 1, layer, 3)) {
            t.setColor(sideBrightness1, sideBrightness1, sideBrightness1);
            block.renderFace(t, x, y, z, 3);
        }
        if (this.shouldRenderFace(block, cache, x - 1, y, z, layer, 4)) {
            t.setColor(sideBrightness2, sideBrightness2, sideBrightness2);
            block.renderFace(t, x, y, z, 4);
        }
        if (this.shouldRenderFace(block, cache, x + 1, y, z, layer, 5)) {
            t.setColor(sideBrightness2, sideBrightness2, sideBrightness2);
            block.renderFace(t, x, y, z, 5);
        }
    }

    private boolean shouldRenderFace(Block block, ChunkCache cache, int x, int y, int z, int layer, int face) {
        if (!block.shouldCullFace(face)) {
            return cache.isLit(x, y, z) ^ layer == 1;
        }
        Block adjacentBlock = cache.getBlockObject(x, y, z);
        int cullingMode = block.getCullingMode();
        if (cullingMode == 0) {
            return !cache.isSolidBlock(x, y, z) && cache.isLit(x, y, z) ^ layer == 1;
        }
        if (cullingMode == 1) {
            boolean shouldCull;
            boolean bl = shouldCull = adjacentBlock != null && adjacentBlock.blockTag.equals(block.blockTag);
            return !shouldCull && cache.isLit(x, y, z) ^ layer == 1;
        }
        if (cullingMode == 2) {
            return cache.isLit(x, y, z) ^ layer == 1;
        }
        return !cache.isSolidBlock(x, y, z) && cache.isLit(x, y, z) ^ layer == 1;
    }

    private void renderBlockFace(Block block, int x, int y, int z, int face) {
        float topBrightness = 1.0f;
        float sideBrightness1 = 0.8f;
        float sideBrightness2 = 0.6f;
        if (face == 0 || face == 1) {
            t.setColor(topBrightness, topBrightness, topBrightness);
        } else if (face == 2 || face == 3) {
            t.setColor(sideBrightness1, sideBrightness1, sideBrightness1);
        } else {
            t.setColor(sideBrightness2, sideBrightness2, sideBrightness2);
        }
        block.renderFace(t, x, y, z, face);
    }

    private void collectFacesToRender(Block block, ChunkCache cache, int layer, int x, int y, int z, Map<String, List<FaceToRender>> facesByTexture) {
        int face = 0;
        while (face < 6) {
            int checkX = x;
            int checkY = y;
            int checkZ = z;
            switch (face) {
                case 0: {
                    --checkY;
                    break;
                }
                case 1: {
                    ++checkY;
                    break;
                }
                case 2: {
                    --checkZ;
                    break;
                }
                case 3: {
                    ++checkZ;
                    break;
                }
                case 4: {
                    --checkX;
                    break;
                }
                case 5: {
                    ++checkX;
                }
            }
            if (this.shouldRenderFace(block, cache, checkX, checkY, checkZ, layer, face)) {
                String texture = block.getTexturePath(face);
                if (texture == null) {
                    texture = "";
                }
                facesByTexture.computeIfAbsent(texture, k -> new ArrayList()).add(new FaceToRender(x, y, z, face, block, false));
            }
            ++face;
        }
    }

    public void rebuild() {
        this.rebuild(0);
        this.rebuild(1);
    }

    public void render(int layer) {
        GL11.glCallList(this.lists + layer);
    }

    public void setDirty() {
        if (!this.dirty) {
            this.dirtiedTime = System.currentTimeMillis();
        }
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public float distanceToSqr(EntityPlayer player) {
        float xd = player.x - this.x;
        float yd = player.y - this.y;
        float zd = player.z - this.z;
        return xd * xd + yd * yd + zd * zd;
    }

    public double centerDistanceToSqr(double px, double pz) {
        double cx = (double)this.x0 + 8.0;
        double cz = (double)this.z0 + 8.0;
        double dx = cx - px;
        double dz = cz - pz;
        return dx * dx + dz * dz;
    }
}

